#ifndef _ExtractDLG_CPP
#define _ExtractDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/Package.H"
#include "../Headers/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/PackingDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define MAX_LOAD_ITEMS 1000

//---------------------(Variable Declarations)
HWND ExtractDialog_hWnd = NULL;

char gsExtractLocation[255 + 1];

HIMAGELIST hImageList;
WNDPROC OldTreeViewProc;

char *AlreadyLoaded[MAX_LOAD_ITEMS];

int LoadedItems = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK NewTreeViewProc(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    LRESULT ReturnVal = CallWindowProc(OldTreeViewProc, xHandle, xMessage, wParam, lParam);

	if(xMessage == WM_LBUTTONDOWN)
	{
        //IndexDirectoryForSubItem(hTreeHandle, SubLeaf, DriveText);
//		GetCursorPos(&xy);	// Where's the mouse?
//		TrackPopupMenuEx(hmenu, TPM_LEFTALIGN|TPM_RIGHTBUTTON, (xy.x) + 1, xy.y, ExtractDialog_hWnd, NULL);
	}

	return ReturnVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CreateTreeImageList(HWND hTreeHandle)
{
    hImageList = ImageList_Create(16, 16, ILC_COLOR24, 10, 1);

    HBITMAP hBitMap = NULL;

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_UNKNOWN));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_REMOVABLE));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_FIXED));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_NETWORK));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_CDROM));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_RAMDRIVE));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_DESKTOP));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_MYDOCS));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_CLOSEDFOLDER));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    hBitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TREE_OPENFOLDER));
    ImageList_Add(hImageList, hBitMap, hBitMap);
    DeleteObject(hBitMap);

    TreeView_SetImageList(hTreeHandle, hImageList, TVSIL_NORMAL);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HTREEITEM TVAddItem(HWND treehwnd, HTREEITEM iparent, char *itext, int Image, int SelImage)
{
	TV_INSERTSTRUCT tvis;

    tvis.item.hItem          = iparent;
    tvis.item.pszText        = itext;
    tvis.item.iImage         = Image;
    tvis.item.iSelectedImage = SelImage;
    tvis.item.mask           = TVIF_TEXT|TVIF_SELECTEDIMAGE|TVIF_IMAGE;
    tvis.hParent             = iparent;
    tvis.item.pszText        = itext;
    tvis.item.cchTextMax     = strlen(itext);

	return TreeView_InsertItem(treehwnd, &tvis);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool MyBrowseDirectory(HWND WindowHandle, char *Title, int Flags, char *ReturnDirectory)
{
    bool Return = false;
    BROWSEINFO browseInfo;
    LPITEMIDLIST lpItemIDList;
    LPMALLOC pMalloc;

    memset(&pMalloc, 0, sizeof(pMalloc));
    memset(&browseInfo, 0, sizeof(browseInfo));
    memset(&lpItemIDList, 0, sizeof(lpItemIDList));
    memset(&Return, 0, sizeof(Return));
    memset(&browseInfo, 0, sizeof(BROWSEINFO));
    memset(ReturnDirectory, 0, MAX_PATH);

    if(S_OK != SHGetMalloc(&pMalloc))
    {
        return 0;
    }

    browseInfo.hwndOwner      = WindowHandle;
    browseInfo.pszDisplayName = ReturnDirectory;
    browseInfo.lpszTitle      = Title;
    browseInfo.ulFlags        = Flags;
    browseInfo.pidlRoot       = NULL;

    if((lpItemIDList = SHBrowseForFolder(&browseInfo)) != NULL)
    {
        memset(ReturnDirectory, 0, MAX_PATH);

        if(SHGetPathFromIDList(lpItemIDList, ReturnDirectory))
        {
            if(strlen(ReturnDirectory) > 0)
            {
                Return = true;
            }
        }
        pMalloc -> Free(lpItemIDList);
    }
    pMalloc -> Release();

    return Return;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsAlreadyLoaded(char *inFolder)
{
    int LocalLoop = 0;

    while(LocalLoop < LoadedItems)
    {
        if(strcmpi(inFolder, AlreadyLoaded[LocalLoop]) == 0)
        {
            return true;
        }
        LocalLoop++;
    }
    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FreeAlreadyLoaded(void)
{
    int LocalLoop = 0;

    while(LocalLoop < LoadedItems)
    {
        free(AlreadyLoaded[LocalLoop]);
        AlreadyLoaded[LocalLoop] = NULL;
        LocalLoop++;
    }

    LoadedItems = 0;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IndexDirectoryForSubItem(HWND hTreeHandle, HTREEITEM SubLeaf, char *inFolder)
{
    if(IsAlreadyLoaded(inFolder))
    {
        return true;
    }

	WIN32_FIND_DATA FindData;
	HANDLE FileHandle = NULL;

	char DirTemp[257];

	sprintf(DirTemp, "%s\\*.*", inFolder);
	if((FileHandle = FindFirstFile(DirTemp, &FindData)) == INVALID_HANDLE_VALUE)
    {
        return false;
    }

    AlreadyLoaded[LoadedItems] = (char *) calloc(sizeof(char), strlen(inFolder) + 1);
    strcpy(AlreadyLoaded[LoadedItems], inFolder);
    LoadedItems++;

	do{
		if( strcmp(FindData.cFileName, ".") && strcmp(FindData.cFileName, "..") )
		{
			if(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
                HTREEITEM RootLeaf = TVAddItem(hTreeHandle, SubLeaf, FindData.cFileName, 8, 9);
			}
        }
	} while(FindNextFile(FileHandle, &FindData));

	FindClose(FileHandle);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopBrowseTree(HWND hTreeHandle)
{
    HTREEITEM RootLeaf, SubLeaf;

    int DriveLoop = 65;  //Drive A
    char DriveText[5];
    int DriveType = 0;
    int Image = 0;

    RootLeaf = TVAddItem(hTreeHandle, TVI_ROOT, "Desktop", 6, 6);

    while(DriveLoop < 90) //Drive Z
    {
        sprintf(DriveText, "%c:", DriveLoop);
        if((DriveType = GetDriveType(DriveText)) != 1)
        {
            if(DriveType == 0) Image = 0; //Unknown Type
            if(DriveType == 2) Image = 1; //Removable Disk
            if(DriveType == 3) Image = 2; //Fixed Disk
            if(DriveType == 4) Image = 3; //Remote Network Drive
            if(DriveType == 5) Image = 4; //Cd-Rom Drive
            if(DriveType == 6) Image = 5; //High Speed RAM Drive

            SubLeaf = TVAddItem(hTreeHandle, RootLeaf, DriveText, Image, Image);

            if(DriveType == 3)
            {
                IndexDirectoryForSubItem(hTreeHandle, SubLeaf, DriveText);
            }
        }

        DriveLoop++;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetDesktopFolderPath(char *Desktop)
{
    DWORD SizeOfBuffer = MAX_PATH;

     if(Get_StringRegistryValue(HKEY_LOCAL_MACHINE, COMMONSHELLFOLDERS, "Common Desktop", Desktop, SizeOfBuffer))
         return true;
     else return false;

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ExtractDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    static HWND SelectedRadio_hWnd = NULL;
    static HWND AllFilesRadio_hWnd = NULL;
    static HWND OverwriteCB_hWnd = NULL;
    static HWND SkipOlderFilesCB_hWnd = NULL;
    static HWND UseFolderNamesCB_hWnd = NULL;
    static HWND ExtractToLocation_hWnd = NULL;
    static HWND BrowseTree_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ExtractDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        SelectedRadio_hWnd     = GetDlgItem(xHandle, IDC_SELECTEDRADIO);
        AllFilesRadio_hWnd     = GetDlgItem(xHandle, IDC_ALLRADIO);
        OverwriteCB_hWnd       = GetDlgItem(xHandle, IDC_OVERWRITE);
        SkipOlderFilesCB_hWnd  = GetDlgItem(xHandle, IDC_SKIPOLDER);
        UseFolderNamesCB_hWnd  = GetDlgItem(xHandle, IDC_USEFOLDERS);
        ExtractToLocation_hWnd = GetDlgItem(xHandle, IDC_EXTRACTLOCATION);
        BrowseTree_hWnd        = GetDlgItem(xHandle, IDC_BROWSETREE);

        OldTreeViewProc = (WNDPROC) SetWindowLong(BrowseTree_hWnd, GWL_WNDPROC, (long) &NewTreeViewProc);

        InvalidateRect(BrowseTree_hWnd, NULL, 0);

        if(ListView_GetSelectedCount(FileList_hWnd) > 0)
        {
            CheckDlgButton(xHandle, IDC_SELECTEDRADIO, BST_CHECKED);
            CheckDlgButton(xHandle, IDC_ALLRADIO, BST_UNCHECKED);
            EnableWindow(SelectedRadio_hWnd, TRUE);
        }
        else {
            CheckDlgButton(xHandle, IDC_ALLRADIO, BST_CHECKED);
            CheckDlgButton(xHandle, IDC_SELECTEDRADIO, BST_UNCHECKED);
            EnableWindow(SelectedRadio_hWnd, FALSE);
        }

        Set_Text(ExtractToLocation_hWnd, "C:\\");

        CreateTreeImageList(BrowseTree_hWnd);

        PopBrowseTree(BrowseTree_hWnd);

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_NOTIFY)
    {
        NMHDR *lpNMH = (LPNMHDR) lParam;

        if(lpNMH->code == TVN_SELCHANGED)
        {
            HTREEITEM hItem = TreeView_GetSelection(BrowseTree_hWnd);
            HTREEITEM hParent = NULL;

            char FullSelectedPath[MAX_PATH + 1];
            char Itemtext[MAX_PATH];
            char SelectedPath[MAX_PATH + 1];

            int RPos = 0;
            int WPos = MAX_PATH;

            TVITEMEX tvItemEx;
            tvItemEx.hItem          = hItem;
            tvItemEx.mask           = TVIF_TEXT;
            tvItemEx.pszText        = Itemtext;
            tvItemEx.cchTextMax     = MAX_PATH;
            TreeView_GetItem(BrowseTree_hWnd, &tvItemEx);

            if(strcmpi(Itemtext, "Desktop") == 0)
            {
                if(GetDesktopFolderPath(FullSelectedPath))
                {
                    Set_Text(ExtractToLocation_hWnd, FullSelectedPath);
                }
                return TRUE;
            }

            SelectedPath[WPos--] = '\\';

            RPos = strlen(Itemtext) - 1;
            while(RPos != -1)
            {
                if(Itemtext[RPos] == '\0') break;
                SelectedPath[WPos] = Itemtext[RPos];
                WPos--;
                RPos--;
            }

            hParent = hItem;

            while( (hParent = TreeView_GetParent(BrowseTree_hWnd, hParent)))
            {
                tvItemEx.hItem          = hParent;
                tvItemEx.mask           = TVIF_TEXT;
                tvItemEx.pszText        = Itemtext;
                tvItemEx.cchTextMax     = MAX_PATH;
                TreeView_GetItem(BrowseTree_hWnd, &tvItemEx);

                if(strcmpi(Itemtext, "Desktop") == 0)
                {
                    break;
                }

                SelectedPath[WPos--] = '\\';

                RPos = strlen(Itemtext) -1;
                while(RPos != -1)
                {
                    if(Itemtext[RPos] == '\0') break;
                    SelectedPath[WPos] = Itemtext[RPos];
                    WPos--;
                    RPos--;
                }
            }

            RPos = WPos+1;
            WPos = 0;
            while(RPos != MAX_PATH+1)
            {
                if(SelectedPath[RPos] == '\0') break;

                FullSelectedPath[WPos] = SelectedPath[RPos];
                WPos++;
                RPos++;
            }

            FullSelectedPath[WPos] = '\0';

            Set_Text(ExtractToLocation_hWnd, FullSelectedPath);

            IndexDirectoryForSubItem(BrowseTree_hWnd, hItem, FullSelectedPath);
            return TRUE;
        }

//      if(lpNMH->code == NM_CLICK)
//      {
//          MessageBox(ExtractToLocation_hWnd, "NM_CLICK", gsTitleCaption, 0);
//      }
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_EXTRACT)
        {
            int Length = Get_TextEx(ExtractToLocation_hWnd, gsExtractLocation, 255);
            if(Length <= 0 || Length > 255)
            {
                MessageBox(ExtractToLocation_hWnd, "You must specifiy a location to extract the files to.", gsTitleCaption, 0);
                return TRUE;
            }

            if(IsDlgButtonChecked(xHandle, IDC_SELECTEDRADIO))
            {
                gdwCurrentJobType = JOB_TYPE_EXTRACTSEL;
            }
            else {
                gdwCurrentJobType = JOB_TYPE_EXTRACTALL;
            }

            EndDialog(xHandle, 1);
            FreeAlreadyLoaded();

            return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
            FreeAlreadyLoaded();
            EndDialog(xHandle, 0);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        FreeAlreadyLoaded();
        EndDialog(xHandle, 0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

